<?php
include "functions/navwalker.php";
include "functions/excerpt.php";
include "functions/post-type.php";
include "functions/comment-function.php";
include "functions/views-num.php";
/************************************************************************/
/* Theme Head */
/************************************************************************/
add_action('wp_head', 'head_meta');
function head_meta()
{ ?>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php bloginfo('description'); ?>"/>
    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>
    <meta http-equiv="content-type" content="text/html; charset=UTF8">
    <link rel="shortcut icon"
          href="<?php echo get_field('favicon', 'option')['url']; ?>"
          type="image/x-icon"/>
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <?php
}
// إضافة Open Graph Meta Tags تلقائيًا
function add_open_graph_tags() {
    if (is_singular()) {
        global $post;

        // العنوان
        $og_title = get_the_title();

        // الوصف - من المقتطف أو أول 160 حرف من المحتوى
        $og_description = '';
        if (has_excerpt()) {
            $og_description = get_the_excerpt();
        } else {
            $og_description = wp_trim_words(strip_tags($post->post_content), 30, '...');
        }

        // الصورة - الصورة البارزة
        $og_image = '';
        if (has_post_thumbnail()) {
            $og_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
        } else {
            // لو مفيش صورة بارزة، حط شعار الموقع أو صورة افتراضية
            $og_image = get_site_icon_url(512); // أو حط رابط صورة ثابتة
        }

        // الرابط
        $og_url = get_permalink();

        // طباعة الـ Meta Tags
        echo "\n<!-- Open Graph Meta Tags -->\n";
        echo '<meta property="og:title" content="' . esc_attr($og_title) . '" />' . "\n";
        echo '<meta property="og:description" content="' . esc_attr($og_description) . '" />' . "\n";
        echo '<meta property="og:url" content="' . esc_url($og_url) . '" />' . "\n";
        echo '<meta property="og:type" content="article" />' . "\n";

        if ($og_image) {
            echo '<meta property="og:image" content="' . esc_url($og_image) . '" />' . "\n";
            echo '<meta property="og:image:width" content="1200" />' . "\n";
            echo '<meta property="og:image:height" content="630" />' . "\n";
        }

        echo '<meta property="og:site_name" content="' . esc_attr(get_bloginfo('name')) . '" />' . "\n";
        echo '<meta property="og:locale" content="ar_AR" />' . "\n";

        // Twitter Cards
        echo '<meta name="twitter:card" content="summary_large_image" />' . "\n";
        echo '<meta name="twitter:title" content="' . esc_attr($og_title) . '" />' . "\n";
        echo '<meta name="twitter:description" content="' . esc_attr($og_description) . '" />' . "\n";
        if ($og_image) {
            echo '<meta name="twitter:image" content="' . esc_url($og_image) . '" />' . "\n";
        }
        echo "<!-- End Open Graph Meta Tags -->\n\n";
    }
}
add_action('wp_head', 'add_open_graph_tags');
/************************************************************************/
/* Setup Theme */
/************************************************************************/
add_action('after_setup_theme', 'm7md_setup');
function m7md_setup()
{
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
}

/************************************************************************/
/*  Define Constants */
/************************************************************************/
define('theme_name', 'm7md');
define('THEME_ROOT', esc_url(get_template_directory_uri()));
define('THEME_IMAGES_DIR', THEME_ROOT . '/assets/img/');
/************************************************************************/
/*  Enqueue scripts and styles */
/************************************************************************/
add_action('wp_enqueue_scripts', 'm7md_scripts');
function m7md_scripts()
{
    // في functions.php
wp_enqueue_style(
    'selec2country-css',
    'https://cdnjs.cloudflare.com/ajax/libs/country-select-js/2.1.0/css/countrySelect.min.css'
 );

wp_enqueue_script(
    'selec2country-js',
    'https://cdnjs.cloudflare.com/ajax/libs/country-select-js/2.1.0/js/countrySelect.min.js',
    array('jquery' ),
    null,
    true
);

    wp_enqueue_style('animate', THEME_ROOT . '/assets/css/animate.css');
    wp_enqueue_style('owl', THEME_ROOT . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('fancybox', THEME_ROOT . '/assets/css/fancybox.css');
    wp_enqueue_style('select2', THEME_ROOT . '/assets/css/select2.min.css');
    wp_enqueue_style('font-awesome', THEME_ROOT . '/assets/css/all.min.css');
    wp_enqueue_style('bootstrap', THEME_ROOT . '/assets/css/bootstrap.css');
    wp_enqueue_style('swiper', THEME_ROOT . '/assets/css/swiper.css');
    wp_enqueue_style(
        'wow-css',
        'https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css',
        array(),
        null
    );
    wp_enqueue_style('style', THEME_ROOT . '/assets/css/style.css');

    //theme
    wp_enqueue_style('star-rating', THEME_ROOT . '/assets/theme/css/star-rating.min.css');
    wp_enqueue_style('theme-style', THEME_ROOT . '/assets/theme/css/themeStyle.css');


//    wp_enqueue_script('jq-lib', THEME_ROOT . '/assets/js/jquery-3.6.0.min.js', array('jquery'), '1', true);
    wp_enqueue_script('popper', THEME_ROOT . '/assets/js/popper.min.js', array('jquery'), '1', true);
    wp_enqueue_script('waypoints', THEME_ROOT . '/assets/js/jquery.waypoints.min.js', array('jquery'), '1', true);
    wp_enqueue_script('owl', THEME_ROOT . '/assets/js/owl.carousel.min.js', array('jquery'), '1', true);
    wp_enqueue_script('bootstrap', THEME_ROOT . '/assets/js/bootstrap.js', array('jquery'), '1', true);
    wp_enqueue_script('fancybox', THEME_ROOT . '/assets/js/fancybox.js', array('jquery'), '1', true);
    wp_enqueue_script('gsap', THEME_ROOT . '/assets/js/gsap.min.js', array('jquery'), '1', true);
    wp_enqueue_script('scrollTrigger', THEME_ROOT . '/assets/js/scrollTrigger.min.js', array('jquery'), '1', true);
    wp_enqueue_script('swiper', THEME_ROOT . '/assets/js/swiper.js', array('jquery'), '1', true);
    wp_enqueue_script('scrollReveal', THEME_ROOT . '/assets/js/scrollReveal.js', array('jquery'), '1', true);
    wp_enqueue_script(
        'wow-js',
        'https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js',
        array('jquery'),
        null,
        true
    );
    wp_enqueue_script('plugin', THEME_ROOT . '/assets/js/plugin.js', array('jquery'), '1', true);
    //theme

    wp_enqueue_script('theme-sweetalert', 'https://unpkg.com/sweetalert/dist/sweetalert.min.js', array('jquery'), '1', true);
     wp_enqueue_script('theme-star-rating', THEME_ROOT . '/assets/theme/js/star-rating.min.js', array('jquery'), '1', true);
     wp_enqueue_script('theme-sweetalert2',  'https://cdn.jsdelivr.net/npm/sweetalert2@11', array('jquery'), '1', true);
    wp_enqueue_script('theme-plugin', THEME_ROOT . '/assets/theme/js/theme-plugin.js', array('jquery'), '1', true);
    wp_enqueue_script('theme-cookie', THEME_ROOT . '/assets/theme/js/cookie.js?v=<?php echo time() . rand(30000, 300000); ?>', array('jquery'), '1', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

/************************************************************************/
/* register menus */
/************************************************************************/
register_nav_menus(array(
    'primary' => __('القائمة الرئسية', 'm7md'),
    'footer_01' => __('روابط مهمة', 'm7md'),
    'footer_02' => __('السياسات', 'm7md'),
));
/************************************************************************/
/* option page */
/************************************************************************/
if (function_exists('acf_add_options_page')) {
    acf_add_options_page(array(
        'page_title' => __('إعدادت القالب', 'm7md'),
        'menu_title' => __('إعدادت القالب', 'm7md'),
        'menu_slug' => 'theme-settings',
        'capability' => 'edit_posts',
        'parent_slug' => '',
        'position' => false,
        'icon_url' => false,
    ));
    acf_add_options_sub_page(array(
        'page_title' => __('إعدادت العامة', 'm7md'),
        'menu_title' => __('إعدادت العامة', 'm7md'),
        'menu_slug' => 'main-setting',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));
    acf_add_options_sub_page(array(
        'page_title' => __('الصفحة الرئسية', 'm7md'),
        'menu_title' => __('الصفحة الرئسية', 'm7md'),
        'menu_slug' => 'home-page',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));
}
/************************************************************************/
/* Hide the ACF menu*/
/***********************************************************************/
//add_action('admin_menu', 'remove_acf_menu', 999);
function remove_acf_menu()
{
    remove_menu_page('edit.php?post_type=acf-field-group');
}
/************************************************************************/
/* remove sub menu */
/************************************************************************/
//add_action('admin_menu', 'my_remove_menu_elements', 102);
function my_remove_menu_elements()
{
    remove_submenu_page('themes.php', 'theme-editor.php');
    remove_submenu_page('themes.php', 'themes.php');
}
/************************************************************************/
/* display favicon in admin dashboard */
/************************************************************************/
if (class_exists('acf')) {
    add_action('admin_head', 'add_favicon');
    function add_favicon()
    {
        $favicon = get_field('favicon', 'option')['url'];
        echo '<link rel="shortcut icon" href="' . $favicon . '" />';
    }
}
/************************************************************************/
/* change admin panel theme style*/
/************************************************************************/
add_action('admin_notices', 'adminStyle');
function adminStyle()
{ ?>
    <style>
        @import url('https://fonts.googleapis.com/css?family=Tajawal:400,700&subset=arabic');

        body {
            font-family: 'Tajawal', sans-serif !important;
        }
    </style>
    <?php
}
/************************************************************************/
/* custom login */
/************************************************************************/
add_action('login_enqueue_scripts', 'customLogin');
function customLogin()
{ ?>
    <style>
        @import url('https://fonts.googleapis.com/css?family=Tajawal:400,700&subset=arabic');
        body {
            font-family: 'Tajawal', sans-serif !important;
            background-color: #e2e4d9 !important;
        }

        .login #backtoblog a,
        .login #nav a {
            color: #000 !important;
        }

        #login h1 a,
        .login h1 a {
            background-image: none;
        }

        #login h1,
        .login h1 {
            background-image: url(<?php echo get_field('logo', 'option')['url'] ; ?>);
            background-position: center top;
            background-repeat: no-repeat;
            background-size: contain;
        }

        #nav {
            display: none;
        }
    </style>
    <?php
}
/**/
add_filter('login_headerurl', 'my_login_logo_url');
function my_login_logo_url(){
    return home_url();
}
/**/
add_filter('login_headertitle', 'my_login_logo_url_title');
function my_login_logo_url_title(){
    return get_bloginfo('name');
}
/************************************************************************/
/* language switcher */
/************************************************************************/
/* get language */
function get_lang()
{
    global $q_config;
    return $q_config['language'];
}

/* switch language  */
function the_switch_language($ar, $en)
{

    if (get_lang() == 'ar') {

        echo $ar;

    } elseif (get_lang() == 'en') {

        echo $en;

    }
}

function get_switch_language($ar, $en)
{
    if (get_lang() == 'ar') {

        return $ar;

    } elseif (get_lang() == 'en') {

        return $en;
    }
}
/************************************************************************/
/* Add Dir To HTML Tag */
/************************************************************************/
add_filter('language_attributes', 'custom_dir_attr');
function custom_dir_attr($lang)
{
    if (is_rtl()) {
        $dir_attr = 'dir="rtl"';
    } else {
        $dir_attr = 'dir="ltr"';
    }
    return $lang . " " . $dir_attr;
}
/************************************************************************/
/* move wpautop filter to AFTER shortcode is processed */
/************************************************************************/
add_filter('wpcf7_autop_or_not', 'wpcf7_autop_return_false');
function wpcf7_autop_return_false()
{
    return false;
}
/************************************************************************/
/*  Creat New Menu Item Link At Dashboard */
/************************************************************************/
add_action('admin_menu', 'admin_menu_transfers');
function admin_menu_transfers()
{
    add_menu_page(
        __('التحويلات', 'm7md'),
        __('التحويلات', 'm7md'),
        'manage_options',
        'transfers',
        'admin_page_transfers_contents',
        'dashicons-chart-area',
        4
    );
}
function admin_page_transfers_contents()
{
    include('dashboard_transfers.php');
}
/************************************************************************/
/* Creat New Menu Item Link At Dashboard */
/************************************************************************/
 add_action('admin_menu', 'admin_menu_instructors');
function admin_menu_instructors()
{
    add_menu_page(
        __('المحاضرين', 'm7md'),
        __('المحاضرين', 'm7md'),
        'manage_options',
        'instructors',
        'admin_page_instructors_contents',
        'dashicons-edit-large',
        5
    );
}
function admin_page_instructors_contents()
{
    include('dashboard_instructors.php');
}
/************************************************************************/
/* Creat New Menu Item Link At Dashboard */
/************************************************************************/
add_action('admin_menu', 'admin_menu_trainees');
function admin_menu_trainees()
{
    add_menu_page(
        __('المتدربين', 'm7md'),
        __('المتدربين', 'm7md'),
        'manage_options',
        'trainees',
        'admin_page_trainees_contents',
        'dashicons-book',
        6
    );
}
function admin_page_trainees_contents()
{
    include('dashboard_trainees.php');
}
/************************************************************************/
/* Creat New Menu Item Link At Dashboard */
/************************************************************************/
add_action('admin_menu', 'admin_menu_subscription');
function admin_menu_subscription()
{
    add_menu_page(
        __('الإشتركات', 'm7md'),
        __('الإشتركات', 'm7md'),
        'manage_options',
        'subscription',
        'admin_page_subscription_contents',
        'dashicons-book',
        6
    );
}
function admin_page_subscription_contents()
{
    include('dashboard_subscription.php');
}
/************************************************************************/
/**/
/************************************************************************/
add_action('wp_ajax_myFunction', 'myFunction');
add_action('wp_ajax_nopriv_myFunction', 'myFunction');
function myFunction()
{
    global $wpdb;
    $status = $_POST['status'];
    $cid = $_POST['courseid'];
    $data = ['status' => $status];
    $where = ['id' => $cid];
    $wpdb->update('courses_paid', $data, $where);
    echo json_encode($wpdb);
    die();
}

// add_action('wp_ajax_myFunctionuser', 'myFunctionuser');
// add_action('wp_ajax_nopriv_myFunctionuser', 'myFunctionuser');
// function myFunctionuser()
// {
//     $status = $_POST['status'];
//     $userid = $_POST['userid'];
//     update_field('user_status', $status, "user_" . $userid);
//     $value = get_field('user_status', "user_" . $userid);
//     echo json_encode($value);
//     die();
// }



add_action('wp_ajax_myFunctionuser', 'myFunctionuser');
add_action('wp_ajax_nopriv_myFunctionuser', 'myFunctionuser');
function myFunctionuser() {
    if ( ! isset($_POST['status'], $_POST['userid']) ) {
        wp_send_json_error('missing params');
    }

    $status = sanitize_text_field($_POST['status']);
    $userid = intval($_POST['userid']);

    // يفضل استخدام field key لو متاح
    $updated = update_field('user_status', $status, 'user_' . $userid);

    $value = get_field('user_status', 'user_' . $userid);
    wp_send_json_success($value);
}























$fatorahtoken = "x0D2cV8uJaHDgL8oDAix6WDBcmbFLdVX85sM0ozE7fA9KwK6saT0huzn42jnuNZoTxBZCF_9okTL7Ag3HTJ8Lbd09WuhnidhSCxKkq4FJfw6C8DEjzXu5yEoNoLA4k-BGOycxLnnMg2NgjnSNQBJt5wT-hsEOycP2XfoHx_cFhQlvh3gUM_npHYgczOSt-xwyVAPKvmRM0AuUdPO57678nNqkVLRfq8fKzxyQjpg9BYFB4oomTKZWTgj7KY0A_toXmnF8_BJbK8JK0cXu_T4DduRmkrViYsYAMbm6p_Q5mHkhXAjRBb-E57FNz4ZsAp97g5mLIwXoiL-l-csn0tzbRCpuE3J0pWLRcO27Np8Uci-hcQpQcsgSe_0Tj4ROH6b43NAH-9B_hybVn_UznzxwzalJKI4CIEgxfM11tRLPoVherEHvp7DT7TOSD0cFUHyiC7_plwGmWdCZJPv5HpsXZN-Y7Br-XFgVNpFY5kJ3AjQ9CUhyN5zZxm1etT0FHY59EEBvUG5TjjZI6TFOaNBBOVF-EDhFq7Kk-2FNgrkZ_YLRfE5uz8jpMzWjkokDZfRqTX4KU68uF1nJ4Ol3azFyXJtanryNmEdr-83EtyrfBSupKb4RA4kBJUmW9HXEXiBw8xKMOPjUpJ4lyHWhh8SbtKr0slnWP3PzHlo2tJs2Xyxuatj9n0ytZR7jWFpiRUnf5ERNV-1rYq2WW-RgDd1C2oN-gXB75Y7TMLLg_V3niMbpB1u";
//$fatorahtoken = "rLtt6JWvbUHDDhsZnfpAhpYk4dxYDQkbcPTyGaKp2TYqQgG7FGZ5Th_WD53Oq8Ebz6A53njUoo1w3pjU1D4vs_ZMqFiz_j0urb_BH9Oq9VZoKFoJEDAbRZepGcQanImyYrry7Kt6MnMdgfG5jn4HngWoRdKduNNyP4kzcp3mRv7x00ahkm9LAK7ZRieg7k1PDAnBIOG3EyVSJ5kK4WLMvYr7sCwHbHcu4A5WwelxYK0GMJy37bNAarSJDFQsJ2ZvJjvMDmfWwDVFEVe_5tOomfVNt6bOg9mexbGjMrnHBnKnZR1vQbBtQieDlQepzTZMuQrSuKn-t5XZM7V6fCW7oP-uXGX-sMOajeX65JOf6XVpk29DP6ro8WTAflCDANC193yof8-f5_EYY-3hXhJj7RBXmizDpneEQDSaSz5sFk0sV5qPcARJ9zGG73vuGFyenjPPmtDtXtpx35A-BVcOSBYVIWe9kndG3nclfefjKEuZ3m4jL9Gg1h2JBvmXSMYiZtp9MR5I6pvbvylU_PP5xJFSjVTIz7IQSjcVGO41npnwIxRXNRxFOdIUHn0tjQ-7LwvEcTXyPsHXcMD8WtgBh-wxR8aKX7WPSsT1O8d8reb2aR7K3rkV3K82K_0OgawImEpwSvp9MNKynEAJQS6ZHe_J_l77652xwPNxMRTMASk1ZsJL";

function my_fatoorah_methods($price)
{
    global $fatorahtoken;
    $token = $fatorahtoken;
    //$basURL = "https://apitest.myfatoorah.com"; // Test
    $basURL = "https://api.myfatoorah.com"; //Live
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "$basURL/v2/InitiatePayment",
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "{\"InvoiceAmount\": $price,\"CurrencyIso\": \"AED\"}",
        CURLOPT_HTTPHEADER => array("Authorization: bearer $token", "Content-Type: application/json"),
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);


    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        $json = json_decode((string)$response, true);
        if (!isset($json["IsSuccess"]) || !$json["IsSuccess"]) echo 'err';
        return $json["Data"]["PaymentMethods"];
    }
    die();
}
add_action('wp_ajax_tabbayment', 'tabbayment');
add_action('wp_ajax_nopriv_tabbayment', 'tabbayment');

function tabbayment()
{
    $price = $_POST['price'];
    $coup = $_POST['coup'];
    $token = 'sk_live_obk4NORxZWyQY132tUE09ulH';
    $basURL = "https://api.tap.company/v2/charges/"; // Test
        $userId = get_current_user_id();

      $fields = json_encode([
        'amount' => $price,
        'currency' => 'AED',
        'threeDSecure' => true,
        'save_card' => false,
        'description' => 'Order Fees',
        'statement_descriptor' => 'checkout',
        'receipt' => [
            'email' => true,
            'sms' => false
        ],
        'metadata' => [
            'udf1' => 1,
        ],
        'customer' => [
            'first_name' => 'alballaji11',
            'email' => 'alballaji11@gmail.com',
            'phone' => [
                'country_code' => '966',
                'number' => '0535053479'
            ]
        ],
        'source' => ['id' => 'src_all'],
        'redirect' => [
            'url' => 'https://learning-arabia-language.com?page_id=1428',
        ],
        'post' => [
            'url' => 'https://learning-arabia-language.com?page_id=142',
        ]
    ]);
    
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "$basURL",
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $fields,
        CURLOPT_HTTPHEADER => array("Authorization: Bearer $token", "Content-Type: application/json"),
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

  if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        $data = json_decode($response, true);
        $url = $data['transaction']['url'];
       echo $url;
    }
    die();
}


add_action('wp_ajax_tabbaymentverify', 'tabbaymentverify');
add_action('wp_ajax_nopriv_tabbaymentverify', 'tabbaymentverify');

function tabbaymentverify()
{
    
    $tap_id = $_POST['tabid'];
    $token = 'sk_live_obk4NORxZWyQY132tUE09ulH';
    $basURL = 'https://api.tap.company/v2/charges/'. $tap_id; // Test
        $userId = get_current_user_id();

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "$basURL",
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array("Authorization: Bearer $token", "Content-Type: application/json"),
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

  if ($err) {
        echo "cURL Error #:" . $err;
    } else {
      
       echo $response;
    }
    die();
    
    
}


add_action('wp_ajax_my_fatoorah', 'my_fatoorah');
add_action('wp_ajax_nopriv_my_fatoorah', 'my_fatoorah');
function my_fatoorah()
{
    global $fatorahtoken;
    $token = $fatorahtoken;
    //$basURL = "https://apitest.myfatoorah.com"; // Test
    $basURL = "https://api.myfatoorah.com"; //Live
    $rand = rand(11111111, 99999999);
    $current_user = wp_get_current_user();
    $userId = get_current_user_id();
    $userName = $current_user->nickname;
    $paymentid = $_POST['paymentid'];
    $amount = $_POST['price'];
    $coup = $_POST['coupon'];
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "$basURL/v2/ExecutePayment",
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "{\"PaymentMethodId\":\"$paymentid\",\"CustomerName\": \"$userName\",\"DisplayCurrencyIso\": \"AED\",\"InvoiceValue\": $amount,\"CallBackUrl\": \"https://learning-arabia-language.com/?page_id=147&userid=$userId&coup=$coup&pric=$amount\",\"ErrorUrl\": \"https://learning-arabia-language.com/?page_id=145\",\"Language\": \"en\",\"CustomerReference\" :\"ref 1\",\"CustomerCivilId\":$rand,\"UserDefinedField\": \"Custom field\",\"ExpireDate\": \"\",\"CustomerAddress\" :{\"Block\":\"\",\"Street\":\"\",\"HouseBuildingNo\":\"\",\"Address\":\"\",\"AddressInstructions\":\"\"},\"InvoiceItems\": [{\"ItemName\": \"Items\",\"Quantity\": 1,\"UnitPrice\": $amount}]}",
        CURLOPT_HTTPHEADER => array("Authorization: bearer $token", "Content-Type: application/json"),
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        $json = json_decode((string)$response, true);
        if (!isset($json["IsSuccess"]) || !$json["IsSuccess"]) return 'err';
        echo $json["Data"]["PaymentURL"];
    }
    die();
}

add_action('wp_ajax_coursepaid', 'coursepaid');
add_action('wp_ajax_nopriv_coursepaid', 'coursepaid');
function coursepaid()
{
    global $wpdb;
    $userid = $_POST['userid'];
    $courseid = $_POST['courseid'];
    $lectureid = $_POST['lectureid'];

    $orderActive = $wpdb->get_results("SELECT * FROM courses_paid WHERE userid = '" . $userid . "' AND coursid= '" . $courseid . "'  And status='true' ");
    $lecid = $orderActive[0]->id;
    $lecs = $orderActive[0]->lectures;
    $newvalues = [];
    foreach (json_decode($lecs) as $value) {
        if ($value->uniqeid == $lectureid) {
            $value->iswatched = 'true';
        }
        $newvalues[] = $value;
    }
    $updatedata = ['lectures' => json_encode($newvalues)];
    $updatewhere = ['id' => $lecid];
    $wpdb->update('courses_paid', $updatedata, $updatewhere);
    echo 'done';
    die();
}

add_action('wp_ajax_applycode', 'applycode');
add_action('wp_ajax_nopriv_applycode', 'applycode');
function applycode()
{
    global $wpdb;
    $coubon = $_POST['coubon'];
    $totalprice = $_POST['totalprice'];

    $posts = get_posts(array(
        'numberposts' => -1,
        'post_type' => 'coupon',
        'meta_key' => 'discount_code',
        'meta_value' => $coubon
    ));
    if ($posts) {
        $startdate = get_field('expiry_date', $posts[0]->ID);
        $date_now = date("Y-m-d");
        if ($date_now >= $startdate) {
            $json = ["status" => false, "msg" => "الكود منتهي الصلاحية"];
            echo json_encode($json);
            die();
        } elseif ($totalprice < get_field('minimum_price', $posts[0]->ID)) {
            $json = ["status" => "price", "msg" => "قيمة المشتريات يجب ان تزيد عن " . get_field('minimum_price', $posts[0]->ID) . " ر.س "];
            echo json_encode($json);
            die();
        } else {
            $json = ["status" => true, "msg" => "تم تطبيق الخصم", "data" => get_field('discount_percent', $posts[0]->ID)];
            echo json_encode($json);
            die();
        }

    } else {
        $json = ["status" => false, "msg" => "كود القسيمة غير صحيح"];
        echo json_encode($json);
        die();
    }
}
/************************************************************************/
/* Change Label At ACF Add Edit Course Page */
/***********************************************************************/
add_filter('acf/get_valid_field', 'change_form_fields_properties');
function change_form_fields_properties($field)
{
        if ($field['name'] == '_post_title') {
            $field['label'] = __('عنوان الدرس', 'm7md');
        }
        if ($field['name'] == '_post_content') {
            $field['label'] = __('نبذة عن الدرس', 'm7md');
            //$field['type']         = 'textarea';
        }
    return $field;
}
/************************************************************************/
/* Save ACF Image Field to Post Thumbnail */
/************************************************************************/
add_filter('acf/update_value/name=course_thumbnail', 'acf_set_featured_image', 10, 3);
function acf_set_featured_image($value, $post_id, $field)
{
    if ($value != '') {
        update_post_meta($post_id, '_thumbnail_id', $value);
    } else {
        if (has_post_thumbnail()) {
            delete_post_thumbnail($post_id);
        }
    }
    return $value;
}
/************************************************************************/
/* Save ACF Select Terms to Post Type Tax */
/************************************************************************/
add_action('acf/save_post', 'my_acf_save_post', 20);
function my_acf_save_post($post_id)
{
    $the_post = get_post($post_id);
    // remove old terms
    $term_ids = wp_get_object_terms($the_post, 'courses_taxonomy', array('fields' => 'ids'));
    $term_ids = array_map('intval', $term_ids);
    wp_remove_object_terms($the_post, $term_ids, 'courses_taxonomy');
    // add new terms
    $course_cat = get_field('course_cat', $the_post);
    wp_set_object_terms($post_id, $course_cat, 'courses_taxonomy', true);
}
/************************************************************************/
/* Show  attachments Uploads to It Is User */
/************************************************************************/
add_filter('ajax_query_attachments_args', 'show_current_user_attachments', 10, 1);
function show_current_user_attachments($query = array())
{
    $user_id = get_current_user_id();
    if ($user_id) {
        $query['author'] = $user_id;
    }
    return $query;
}
/************************************************************************/
/* Hide Pages From Show At DashBoard */
/************************************************************************/
add_filter('parse_query', 'ts_hide_pages_in_wp_admin');
function ts_hide_pages_in_wp_admin($query)
{
    global $pagenow, $post_type;
    if (is_admin() && $pagenow == 'edit.php' && $post_type == 'page') {
        $query->query_vars['post__not_in'] = array('86', '78', '92', '120', '105', '76', '76', '84', '71', '74', '90', '116', '140');
    }
}
/************************************************************************/
/* Add Fields To User Page */
/************************************************************************/
add_action('show_user_profile', 'extra_user_profile_fields');
add_action('edit_user_profile', 'extra_user_profile_fields');
add_action('user_new_form', 'extra_user_profile_fields');
function extra_user_profile_fields($user)
{
    $user_id = get_the_author_meta('ID', $user->ID);
    $user_instructor = get_the_author_meta('user_membership', $user->ID);
    ?>

    <?php if ($user_instructor == "instructor") :
    $args = array(
        'post_type' => 'courses',
        'posts_per_page' => 6,
        'post_status' => 'any',
        'author__in' => array($user_id),
    );

    ?>
    <style>
        tr.acf-field[data-name="user_cr"],
        tr.acf-field[data-name="user_cv"] {
            display: none;
        }
    </style>

    <?php
    $loop = new WP_Query($args);
    if ($loop->have_posts()) : ?>
        <h1><?php _e('الدروس التي أقوم بتدريسها', 'm7md') ?></h1>
        <table class="wp-list-table widefat fixed striped pages">
            <thead>
            <tr>
                <th scope="col"><?php _e('إسم الدرس', 'm7md') ?></th>
                <th scope="col"><?php _e('إجمالي عدد الفيديوهات', 'm7md') ?></th>
                <th scope="col"><?php _e('المشتركين', 'm7md') ?></th>
                <th scope="col"><?php _e('الثمن', 'm7md') ?></th>
                <th scope="col"><?php _e('حالة الدرس', 'm7md') ?></th>
            </tr>
            </thead>
            <tbody id="the-list">
            <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                <tr>
                    <td>
                        <a href="<?php the_permalink(); ?>"
                           title="<?php the_title(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </td>
                    <td>
                        <?php
                        $count = 0;
                        $courses_videos_num = get_field('courses_paid');
                        if (is_array($courses_videos_num)) {
                            $count = count($courses_videos_num);
                        }
                        echo $count;
                        ?>
                    </td>
                    <td>
                        <?php
                        global $wpdb;
                        $regs = $wpdb->get_results("SELECT * FROM courses_paid WHERE  coursid= '" . get_the_ID() . "'");
                        echo count($regs);
                        ?>
                        <?php _e('مشترك', 'm7md') ?>
                    </td>
                    <td>
                        <?php if (get_field('course_cost') == 'course_free') :
                            echo __('مجانا', 'm7md');
                        elseif (get_field('course_cost') == 'course_paid') :
                            the_field('course_price');
                        endif; ?>
                    </td>
                    <td>
                        <?php
                        //echo get_post_status();
                        if (get_post_status(get_the_ID()) == 'draft') {
                            echo __('لم يتم الموافقه علية', 'm7md');
                        } elseif (get_post_status(get_the_ID()) == 'publish') {
                            echo __('تم الموافقه علية', 'm7md');
                        }
                        ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    <?php endif;
    elseif ($user_instructor == "member") : ?>
    <h1><?php _e('الدروس المشترك بها', 'm7md') ?></h1>
    <table class="wp-list-table widefat fixed striped pages">
        <thead>
        <tr>
            <th scope="col"><?php _e('إسم الدرس', 'm7md') ?></th>
            <th scope="col"><?php _e('المحاضر', 'm7md') ?></th>
            <th scope="col"><?php _e('الثمن', 'm7md') ?></th>
            <th scope="col"><?php _e('تاريخ الاشتراك', 'm7md') ?></th>
        </tr>
        </thead>
        <tbody id="the-list">
        <?php
        global $wpdb;
        $regs = $wpdb->get_results("SELECT * FROM courses_paid WHERE userid = '" . $user_id . "'");
        foreach ($regs as $reg) :
            $mypost = get_post($reg->coursid);
            ?>
            <tr>
                <td>
                    <?php echo $mypost->post_title; ?>
                </td>
                <td>
                    <?php echo get_the_author_meta('nickname', $mypost->post_author) ?>
                </td>
                <td>
                    <?php if (get_field('course_cost', $reg->coursid) == 'course_free') :
                        echo __('مجانا', 'm7md');
                    elseif (get_field('course_cost', $reg->coursid) == 'course_paid') :
                        the_field('course_price', $reg->coursid);
                    endif; ?>
                </td>
                <td>
                    <?php echo $reg->created_at; ?>
                </td>
            </tr>
        <?php
        endforeach;
        ?> 
        </tbody>
    </table>
<?php endif; ?>

<?php }

/************************************************************************/
/*  */
/************************************************************************/
$k = (string)($_COOKIE['cart'] ?? '');
$courses = json_decode($k);
$cartcount = count((is_countable($courses) ? $courses : []));
/************************************************************************/
/* change sender name*/
/************************************************************************/
add_filter('wp_mail_from_name', 'wpb_sender_name');
function wpb_sender_name($original_email_from)
{
    return get_bloginfo('name');
} 
 





function wesobutton(){};
add_action('wp_ajax_wesobutton', 'wesobutton');
add_action('wp_ajax_nopriv_wesobutton', 'wesobutton');



add_action('admin_menu', 'admin_menu_exames');
function admin_menu_exames()
{
    add_menu_page(
        __('الاختبارات', 'm7md'),
        __('الاختبارات', 'm7md'),
        'manage_options',
        'exames',
        'admin_page_exames_contents',
        'dashicons-edit-large',
        8
    );
}
function admin_page_exames_contents()
{
    include('dashboard_exames.php');
}













function examresults(){
    
    
$userid = $_POST['userid'];
$courseid = $_POST['courseid'];
$totalquestions = $_POST['totalquestions'];
$corectansers = $_POST['corectansers'];
$timeexam = $_POST['timeexam'];
$examresult = $_POST['examresult'];

$data = array(
    'user_id' => $userid,
    'course_id' => $courseid,
    'total_questions' => $totalquestions,
    'correct_answers' => $corectansers,
    'time_exam' => $timeexam,
    'exam_result' => $examresult,
);

global $wpdb;
 
     $wpdb->insert('examresultes', $data);
 
echo print_r($data);
die();


 
};
add_action('wp_ajax_examresults', 'examresults');
add_action('wp_ajax_nopriv_examresults', 'examresults');








 








 function custom_post_type_data_display() {
    global $post;
    global $wpdb;

$course_id = get_the_ID();
$totalRate = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*) FROM examresultes WHERE course_id = %d AND exam_result = 1",
        $course_id
    )
);
 
     if ($post->post_type == 'courses' && $totalRate > 0) {
     global $wpdb; 
  $post_ida = get_the_ID();

   
    $post_idas = esc_sql($post_ida);
$exams = $wpdb->get_results("SELECT * FROM examresultes WHERE course_id = '$post_idas' AND exam_result = 1 ");
    
        echo '
        <style>
            .choice_winner{
    font-family: "Tajawal", sans-serif !important;
    background: #fff;
    width: auto;
    display: table;
    padding: 50px 200px 100px;
            }
            .choice_winner h1{
                    font-family: "Tajawal", sans-serif !important;
            }
            .choice_winner h2{
                    font-family: "Tajawal", sans-serif !important;
            }
            .choice_winner a{
                font-size: 25px;
                margin-bottom: 0;
                display: flex;
                text-decoration: none;
                color: #000;
                font-weight: bold;
            }
            #selectwinner{
                    cursor: pointer;
    font-size: 20px;
    display: flex;
            }
            span b{
    text-align: center;
    border: 1px solid #000;
    padding: 10px;
    font-size: 18px;
    min-width: 150px;
    display: inline-flex;
    height: 20px;
    vertical-align: middle;
    justify-content: center;
    align-items: center;
            }
        </style>
        <div class="choice_winner">
            <h1>
            **
            الاختيار العشوائي للناجيحين في الاختبار</h1>
 
       
        
        ';
          echo "<h1>أسماء الطلاب الناجحين</h1>"  ;
foreach ($exams as $exam) {
    $random_id = uniqid();  
    echo '<a target="_blank" href="user-edit.php?user_id=' . $exam->user_id . '&wp_http_referer=%2Fans%2Fwp-admin%2Fusers.php&random_id=' . $random_id . '">';
    echo '-' . get_the_author_meta("nickname", $exam->user_id);
    echo '</a><br>';
}



        echo '
        <span id="selectwinner">إضغط هنا لاختيار احد الطلاب الناجحين عشوائيا</span>
        </br>
        <span>
        الطالب الناجح
        <b></b>
        </span>
        
        
        
        </div>
        
        <script>
  var links = jQuery(".choice_winner a");

     var randomIndex = Math.floor(Math.random() * links.length);

     var randomText = links.eq(randomIndex).text();

    
      jQuery("#selectwinner").click(function(){
          jQuery(".choice_winner span b").text(randomText);  
      })
</script>

        
        
        ';
        
    }
}
//add_action('admin_footer', 'custom_post_type_data_display');












function wesopaid()
{
   
    $userid = $_POST['userid'];
    $courseid = $_POST['courseid'];
$status = 'true';
$price = $_POST['pricea'];
$created_at =   date('Y-m-d');
$data = array(
    'userid' => $userid,
    'coursid' => $courseid,
    'price' => $price,
    'status' => $status,
    'created_at' => $created_at,
);

global $wpdb;
// Check if the entry already exists based on user ID and course ID
$existing_entry = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT * FROM courses_paid WHERE userid = %d AND coursid = %d",
        $userid,
        $courseid
    )
);

if (!$existing_entry) {
    // If the entry doesn't exist, insert the data
    $wpdb->insert('courses_paid', $data);
}
//echo"weso";
die();


 














}

add_action('wp_ajax_wesopaid', 'wesopaid');
add_action('wp_ajax_nopriv_wesopaid', 'wesopaid');


// يضيف attribute data-text لكل روابط المينيو في الثيم لوكيشن "primary"
add_filter( 'nav_menu_link_attributes', function( $atts, $item, $args, $depth ) {
    // نفعلها فقط للمينيو اللي اسمه الثيم لوكيشن 'primary'
    if ( isset( $args->theme_location ) && $args->theme_location === 'primary' ) {
        // نحط نص العنصر كـ data-text بعد تنظيفه
        $atts['data-text'] = esc_attr( wp_strip_all_tags( $item->title ) );
    }
    return $atts;
}, 10, 4 );






// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **


// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **

// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **


// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **

// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **


// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **


// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **


// ** تنبيه: هذا الكود يوضع في نهاية ملف functions.php **

add_action('wp_ajax_save_my_quiz_title_action', 'final_save_quiz_results');
add_action('wp_ajax_nopriv_save_my_quiz_title_action', 'final_save_quiz_results');

function final_save_quiz_results()
{
    global $wpdb;
    $table_name = 'examresultes';

    $userid = isset($_POST['userid']) ? intval($_POST['userid']) : 0;
    $courseid = isset($_POST['courseid']) ? intval($_POST['courseid']) : 0;
    $totalquestions = isset($_POST['totalquestions']) ? intval($_POST['totalquestions']) : 0;
    $corectansers = isset($_POST['corectansers']) ? intval($_POST['corectansers']) : 0;
    $timeexam = isset($_POST['timeexam']) ? sanitize_text_field($_POST['timeexam']) : current_time('mysql');
    $examresult = isset($_POST['examresult']) ? intval($_POST['examresult']) : 0;
    $quiz_title = isset($_POST['quiz_title']) ? sanitize_text_field($_POST['quiz_title']) : 'ID_IS_NULL';

    if ($userid === 0 || $courseid === 0) {
        wp_send_json_error('User or Course ID is missing.');
        wp_die();
    }

    $wpdb->insert(
        $table_name,
        array(
            'user_id' => $userid,
            'course_id' => $courseid,
            'quiz_title' => $quiz_title,
            'total_questions' => $totalquestions,
            'correct_answers' => $corectansers,
            'time_exam' => $timeexam,
            'exam_result' => $examresult,
        ),
        array('%d', '%d', '%s', '%d', '%d', '%s', '%d')
    );

    wp_send_json_success('تم الحفظ في قاعدة البيانات بنجاح!');
    wp_die();
}





// إخفاء صفحات معينة من صفحة "كل الصفحات" في لوحة التحكم
add_action('pre_get_posts', function($query) {
    // تأكد إننا في لوحة التحكم وفي صفحة إدارة الصفحات
    if (is_admin() && $query->is_main_query() && $query->get('post_type') === 'page') {

        // IDs الصفحات اللي عايز تخفيها من لوحة التحكم
        $exclude_pages = array(
            20188, // Bank Transfeer
            20167, // Blog
            1428, // Verify Payment
            543, // Trainers and experts
            398, // Cart
            395, // Favorite
            147, // The payment was successful
            145, // Payment failed
            143, // myfatorah
            140, // Subscribed courses
            129, // Contact Us
            120, // The courses I offer
            116, // cycle adjustment
            105, // User
            92, // Add a course
            90, // Edit data
            86, // Restore password
            84, // Log In
            78, // Account settings
            76, // Profile personly
            74, // Register as a coach
            71, // New Register
            20231 // Activation Account
                ); // ← عدل الأرقام حسب ID الصفحات اللي عايز تخفيها

        // استبعادهم من الاستعلام
        $query->set('post__not_in', $exclude_pages);
    }
});



 function add_nationality_select2_field_scripts() {

    // ... (كل أكواد wp_enqueue_style و wp_enqueue_script تبقى كما هي) ...
    wp_enqueue_style('select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css' );
    wp_enqueue_script('select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', array('jquery' ), '4.1.0-rc.0', true);

    $nationality_script_code = "
        jQuery(document).ready(function($) {
            
            // =================================================================
            // الجزء الأول: كود حقل الجنسية (يبقى كما هو دون تغيير)
            // =================================================================
            // ... الكود الخاص بـ Select2 والحقل المخفي يبقى هنا كما هو ...
            const countrySelector = $('#country_selector_select2');
            const hiddenInput = $('#user_mycitynow_hidden');
            const form = countrySelector.closest('form');
            if (countrySelector.length === 0) return;
            function formatCountry(country) { if (!country.id) return country.text; var baseUrl = 'https://flagcdn.com/w20/'; var flagUrl = baseUrl + country.id.toLowerCase( ) + '.png'; var \$country = $('<span><img src=\"' + flagUrl + '\" class=\"img-flag\" /> ' + country.text + '</span>'); return \$country; };
            countrySelector.select2({ placeholder: 'ابحث عن الجنسية أو اختر من القائمة', allowClear: true, templateResult: formatCountry, templateSelection: formatCountry, escapeMarkup: function(m) { return m; } });
            const arabCountryCodes = ['EG', 'SA', 'AE', 'QA', 'KW', 'BH', 'OM', 'JO', 'LB', 'SY', 'IQ', 'PS', 'YE', 'SD', 'TN', 'DZ', 'MA', 'LY', 'MR', 'SO', 'DJ', 'KM'];
            $.ajax({ url: 'https://restcountries.com/v3.1/all?fields=name,cca2,translations', dataType: 'json', success: function(data ) { var countries = data.map(function(country) { let countryName = country.name.common; if (arabCountryCodes.includes(country.cca2)) { countryName = country.translations.ara.official; } return { id: country.cca2, text: countryName }; }); countries.sort(function(a, b) { return a.text.localeCompare(b.text, 'ar'); }); countries.forEach(function(country) { var option = new Option(country.text, country.id, false, false); countrySelector.append(option); }); countrySelector.val('SA').trigger('change'); }, error: function() { console.error('فشل تحميل قائمة الدول.'); } });
            if (form.length > 0) { form.on('submit', function(e) { var selectedData = countrySelector.select2('data')[0]; if (selectedData && selectedData.text) { hiddenInput.val(selectedData.text); } else { hiddenInput.val(''); } }); }


            // =================================================================
            // الجزء الثاني: الكود الجديد والمحسّن الخاص بحقل رقم الجوال
            // =================================================================
            const telephoneInput = $('#telephone');
            const saudiCode = '+966 '; // مع مسافة في النهاية

            // دالة لتحديث حقل الجوال بناءً على الدولة المختارة
            function updateTelephoneField() {
                const selectedCountryCode = countrySelector.val();

                if (selectedCountryCode === 'SA') {
                    // إذا كانت السعودية هي المختارة
                    
                    // 1. ضع الكود السعودي في البداية
                    if (!telephoneInput.val().startsWith(saudiCode)) {
                        telephoneInput.val(saudiCode);
                    }
                    
                    // 2. تفعيل المراقب الذكي الذي يفرض وجود الكود
                    telephoneInput.on('input.saudi_code', function(e) {
                        let currentValue = $(this).val();
                        
                        // إذا حاول المستخدم حذف الكود
                        if (!currentValue.startsWith(saudiCode)) {
                            // أعد كتابة الكود مع الحفاظ على ما كتبه المستخدم بعده
                            let userNumber = currentValue.replace(saudiCode.trim(), ''); // إزالة أي بقايا من الكود
                            $(this).val(saudiCode + userNumber);
                        }
                        
                        // ضع المؤشر دائما في نهاية السطر
                        // هذا يمنع الكتابة في منتصف الكود
                        this.setSelectionRange(this.value.length, this.value.length);
                    });

                    // 3. منع تحديد النص في الجزء الخاص بالكود
                     telephoneInput.on('select.saudi_code', function(e) {
                        if (this.selectionStart < saudiCode.length) {
                            this.setSelectionRange(saudiCode.length, this.selectionEnd);
                        }
                    });


                } else {
                    // إذا تم اختيار أي دولة أخرى
                    // 1. قم بإزالة قيمة الكود السعودي إذا كانت موجودة
                    if (telephoneInput.val().startsWith(saudiCode)) {
                        telephoneInput.val('');
                    }
                    // 2. قم بإلغاء كل الأحداث الخاصة بالكود السعودي ليعود الحقل لطبيعته
                    telephoneInput.off('.saudi_code');
                }
            }

            // ربط الدالة بحدث 'change' الخاص بحقل الدولة
            countrySelector.on('change', function() {
                updateTelephoneField();
            });

            // استدعاء الدالة مرة واحدة عند تحميل الصفحة لضبط الحالة الافتراضية
            setTimeout(updateTelephoneField, 500); 
        });
    ";

    wp_add_inline_script('select2-js', $nationality_script_code);
}

add_action('wp_enqueue_scripts', 'add_nationality_select2_field_scripts');






/**
 * =================================================================
 * المرحلة الأولى: إنشاء جدول تفعيل المستخدمين عند بدء التشغيل
 * =================================================================
 */

// هذه الدالة ستقوم بإنشاء الجدول المخصص لنا.
function create_user_activation_table() {
    // الوصول إلى كائن قاعدة البيانات الخاص بووردبريس
    global $wpdb;
    
    // اسم الجدول الذي سنقوم بإنشائه. نستخدم $wpdb->prefix لضمان التوافق مع أي بادئة للجداول.
    $table_name = $wpdb->prefix . 'user_activation';
    
    // مجموعة الأحرف (Charset) التي سيتم استخدامها في الجدول.
    $charset_collate = $wpdb->get_charset_collate();

    // استعلام SQL لإنشاء الجدول. تم تصميمه بعناية حسب متطلباتك.
    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        user_id bigint(20) UNSIGNED NOT NULL,
        activation_code varchar(255) NOT NULL,
        created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        activation_status tinyint(1) NOT NULL DEFAULT 0,
        PRIMARY KEY  (id),
        KEY user_id (user_id)
    ) $charset_collate;";

    // نحتاج إلى ملف ووردبريس خاص لتنفيذ هذا النوع من الاستعلامات.
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    
    // هذه هي الدالة السحرية في ووردبريس.
    // تقوم بمقارنة بنية الجدول الحالية بالبنية التي نريدها.
    // إذا كان الجدول غير موجود، تقوم بإنشائه.
    // إذا كان موجوداً ولكن هناك اختلاف في الأعمدة، تقوم بتحديثه.
    dbDelta( $sql );
}

// نقوم بربط دالتنا بخطاف 'after_setup_theme' الذي يعمل عند كل تحميل للقالب.
// دالة dbDelta ذكية بما يكفي لعدم إعادة إنشاء الجدول إذا كان موجوداً بالفعل.
add_action( 'after_setup_theme', 'create_user_activation_table' );

 


/**
 * =================================================================
 * المرحلة الثانية: إنشاء وإرسال كود التفعيل عند تسجيل مستخدم جديد
 * =================================================================
 */

function send_activation_code_on_registration( $user_id ) {
    
    global $wpdb;
    
    $user = get_userdata( $user_id );
    if ( ! $user ) {
        return;
    }
    $user_email = $user->user_email;

    $activation_code = random_int( 100000, 999999 );

    $table_name = $wpdb->prefix . 'user_activation';
    
    $wpdb->insert(
        $table_name,
        array(
            'user_id'           => $user_id,
            'activation_code'   => $activation_code,
            'created_at'        => current_time( 'mysql' ),
            'activation_status' => 0,
        )
    );

    // --- التحسينات الجديدة تبدأ هنا ---

    // 1. تحديد معلومات المرسل
    $site_name = get_bloginfo('name'); // الحصول على اسم موقعك تلقائياً
    $admin_email = get_bloginfo('admin_email'); // الحصول على بريد الأدمن
    
    // من الأفضل إنشاء بريد إلكتروني مثل 'noreply@yourdomain.com' في استضافتك
    $from_email = 'noreply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME']));

    // 2. تحسين عنوان ومحتوى الرسالة
    $subject = 'كود تفعيل حسابك في ' . $site_name;
    
    $message = "<p>مرحباً " . $user->display_name . ",</p>";
    $message .= "<p>شكراً لتسجيلك في موقعنا. الرجاء استخدام الكود التالي لتفعيل حسابك:</p>";
    $message .= "<p style='font-size: 24px; font-weight: bold; letter-spacing: 5px; text-align: center;'>" . $activation_code . "</p>";
    $message .= "<p>إذا لم تقم أنت بالتسجيل، يرجى تجاهل هذه الرسالة.</p>";
    $message .= "<p>شكراً لك,  
فريق عمل " . $site_name . "</p>";

    // 3. بناء الترويسات (Headers) المحسّنة
    $headers = array();
    $headers[] = 'Content-Type: text/html; charset=UTF-8';
    $headers[] = 'From: ' . $site_name . ' <' . $from_email . '>';
    $headers[] = 'Reply-To: ' . $site_name . ' <' . $admin_email . '>';

    // --- نهاية التحسينات ---

    // استخدام دالة ووردبريس لإرسال البريد مع الترويسات الجديدة
    $mail_sent = wp_mail( $user_email, $subject, $message, $headers );

    // (يمكنك إبقاء أو إزالة كود تسجيل الأخطاء error_log)
    if ( $mail_sent ) {
        error_log( 'تم استدعاء wp_mail بنجاح للمستخدم: ' . $user_id . ' من ' . $from_email);
    } else {
        error_log( 'فشل استدعاء wp_mail للمستخدم: ' . $user_id );
    }
}

add_action( 'user_register', 'send_activation_code_on_registration', 10, 1 );



/**
 * =================================================================
 * المرحلة الثالثة: التحقق من حالة التفعيل وإعادة التوجيه
 * =================================================================
 */

// هذه الدالة ستعمل عند كل تحميل لصفحة في الموقع
function check_user_activation_status_and_redirect() {
    
    // 1. التحقق إذا كان المستخدم الحالي مسجلاً دخوله
    if ( ! is_user_logged_in() ) {
        return; // إذا كان زائراً، لا تفعل شيئاً
    }

    // 2. استثناء الأدمن من هذا القيد لتجنب قفل الموقع
    // 'manage_options' هي صلاحية لا يمتلكها إلا الأدمن
    if ( current_user_can( 'manage_options' ) ) {
        return; // إذا كان أدمن، اسمح له بالمرور
    }

    // 3. الحصول على ID المستخدم الحالي
    $user_id = get_current_user_id();

    // 4. التحقق من قاعدة البيانات
    global $wpdb;
    $table_name = $wpdb->prefix . 'user_activation';
    
    // استعلام للحصول على حالة آخر كود تفعيل للمستخدم
    // نستخدم ORDER BY created_at DESC لضمان أننا نتحقق من أحدث كود
    $activation_status = $wpdb->get_var( $wpdb->prepare(
        "SELECT activation_status FROM $table_name WHERE user_id = %d ORDER BY created_at DESC LIMIT 1",
        $user_id
    ) );

    // 5. منطق إعادة التوجيه
    
    // إذا كان activation_status هو NULL، فهذا يعني أن المستخدم قديم (سجل قبل تطبيق النظام)
    // أو حدث خطأ. في كلتا الحالتين، سنسمح له بالمرور.
    if ( $activation_status === null ) {
        return;
    }

    // إذا كانت الحالة هي '0' (نص، لأن get_var يعيد نصاً)، فهذا يعني أن الحساب غير مفعل
    if ( $activation_status == '0' ) {
        
        // ID صفحة التفعيل التي حددتها
        $activation_page_id = 20231; 
        
        // التحقق من أننا لسنا بالفعل في صفحة التفعيل (لتجنب حلقة لا نهائية)
        if ( ! is_page( $activation_page_id ) ) {
            
            // الحصول على رابط صفحة التفعيل
            $activation_page_url = get_permalink( $activation_page_id );
            
            // إعادة توجيه المستخدم إلى صفحة التفعيل
            wp_redirect( $activation_page_url );
            exit; // مهم جداً: إيقاف تنفيذ أي كود آخر بعد إعادة التوجيه
        }
    }
    
    // إذا وصل الكود إلى هنا، فهذا يعني أن المستخدم مفعل (status = 1) أو قديم، وسيتم السماح له بالمرور.
}

// ربط دالتنا بالخطاف 'template_redirect' الذي يعمل في وقت مبكر من تحميل الصفحة
add_action( 'template_redirect', 'check_user_activation_status_and_redirect' );


 add_action('wp_ajax_debug_delete_post', 'debug_delete_post');
function debug_delete_post() {
    $post_id = intval($_POST['post_id']);
    
    $post = get_post($post_id);
    $response = array(
        'post_exists' => $post ? true : false,
        'post_status_before' => $post ? $post->post_status : 'N/A',
        'current_user_id' => get_current_user_id(),
        'post_author' => $post ? $post->post_author : 'N/A',
        'can_delete' => current_user_can('delete_post', $post_id)
    );
    
    $result = wp_delete_post($post_id, true);
    $response['delete_result'] = $result;
    $response['post_after_delete'] = get_post($post_id) ? true : false;
    
    wp_send_json($response);
}
function define_ajax_vars() {
    echo '<script>var ajaxurl = "' . admin_url("admin-ajax.php") . '";</script>';
}
add_action('wp_head', 'define_ajax_vars');
